<?php

namespace App\Http\Controllers\Hr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use App\Models\CooperationStore;
use App\Models\CustomerPackage;
use App\Models\Appointment;
use App\Models\AppointmentSection;
use App\Models\AppointmentStatus;
use App\Models\HrAppointmentLink;
use App\Models\HrCustomerLink;
use App\Models\HrAppointmentCustomer;
use App\Models\ItemStore;
use App\Models\HrPermissionToUser;



class AppointmentController extends Controller
{
    public $role_id;
    public $permissions;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = HrPermissionToUser::where('hr_role_id', session('hr_role_id'))->get();

        // $this->permissions = $permissions;
        
        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('appointment.appointments', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('appointment.appointment.show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('appointment.appointment.create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('appointment.appointment.update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('appointment.appointment.delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }

        // if(!session('role_id')) {
        //     return redirect()->route('login');
        // }

        // $this->role_id = session('role_id');

    }
    
    public function package_stores(Request $request)
    {
        $data['package_id'] = $request->input('package_id');
        
        $package = CustomerPackage::where('id', $request->input('package_id'))->first();
        
            $stores = ItemStore::with(['store'])->where('item_id', $package->item_id)->get();
        
            return response()->json([
                'package'  => $package,
                'stores'    => $stores,
                'data'  => 'test'    
            ]);    
        
        
    }
    
    public function index()
    {
       
        $appointments = HrAppointmentLink::with(['appointment.customer', 'appointment.statusdetail'])->where('hr_user_id', session('hr_user_id'))->get();

        return response()->json([
            'appointments'  => $appointments,
            'hr_user_id'  => session('hr_user_id'),
            'permission'        => $this->permission,
            'permission_type'   => $this->permission_type,
        ]);
    }
    
    public function create()
    {
        $hr_appointment_customers = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->get();
        
        $customer_links = HrCustomerLink::with(['customer.packages'])->where('hr_user_id', session('hr_user_id'))->get();
        
        $store_all_array = CooperationStore::with(['company'])->where('status', '1')->get();
        
        $statuses = AppointmentStatus::with(['detail'])->where('status', '1')->get(); // all
        
        $sections = AppointmentSection::where('status', '1')->get();
        
        return response()->json([
            'hr_appointment_customers'  => $hr_appointment_customers,
            'customer_links'            => $customer_links,
            'store_all_array'           => $store_all_array,
            'sections'                  => $sections,
            'statuses'                  => $statuses,
        ]);
    }

    public function store(Request $request)
    {
        $section = AppointmentSection::where('id', $request->input('appointment_section_id'))->first();
        $customer_package = CustomerPackage::where('id', $request->input('customer_package_id'))->first();

        $data['customer_type'] = $request->input('customer_type');
        
        if($request->input('customer_type') == 'existing_customer') {
            $appointment_customer = HrAppointmentCustomer::where('id', $request->input('hr_appointment_customer_id'))->where('hr_user_id', session('hr_user_id'))->first();
        }
        
        $data['date'] = $request->input('appointment_date');
        $data['customer_package_id'] = $request->input('customer_package_id');
        $data['title']  = $customer_package->title;
        $data['store_id'] = $request->input('branch_id');
        $data['start'] = $section->start;
        $data['end'] = $section->end;
        $data['status'] = $request->input('status');
        $data['customer_id'] = $request->input('customer_id');
        $data['description'] = $request->input('description') ?? "";
        $data['appointment_section_id'] = $request->input('appointment_section_id');

        $data['allday'] = false;
        $data['uniqid'] = uniqid();

        $appointment = Appointment::create($data);
        
        $appointment_data['hr_appointment_customer_id'] = $request->input('hr_appointment_customer_id') ?? null;
        
        if($request->input('customer_type') == 'custom_customer') {
            
            $customer = json_decode($request->input('appointment_custom_customer'));
            
            $customer_data['hr_user_id'] = session('hr_user_id');
            $customer_data['name'] = $customer->name;
            $customer_data['telephone'] = $customer->telephone;
            $customer_data['email'] = $customer->email;
            $customer_data['country_code'] = $customer->country_code;
            $customer_data['status'] = 1;
            
            $hr_appointment_customer = HrAppointmentCustomer::create($customer_data);
            $appointment_data['hr_appointment_customer_id'] = $hr_appointment_customer->id;
        }
        
        $appointment_data['appointment_id'] = $appointment->id;
        $appointment_data['hr_user_id'] = session('hr_user_id');
        
        HrAppointmentLink::create($appointment_data);

        return response()->json([
            'message' => 'success',
            'data'      => $data,
        ]);

    }

    public function edit(string $uniqid)
    {
        $result = Appointment::where('uniqid', $uniqid)->first();
        
        $appointment = HrAppointmentLink::with(['appointment'])
                            ->where('appointment_id', $result->id)
                            ->where('hr_user_id', session('hr_user_id'))
                            ->first();
        
        $hr_appointment_customers = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->get();
        
        $customer_links = HrCustomerLink::with(['customer.packages'])->get();
        
        $store_all_array = CooperationStore::with(['company'])->where('status', '1')->get();
        
        $statuses = AppointmentStatus::with(['detail'])->where('status', '1')->get(); // all
        
        $sections = AppointmentSection::where('status', '1')->get();
        
        return response()->json([
            'result'    => $result,
            'uniqid'    => $uniqid,
            'hr_appointment_customers'  => $hr_appointment_customers,
            'customer_links'            => $customer_links,
            'store_all_array'           => $store_all_array,
            'sections'                  => $sections,
            'statuses'                  => $statuses,
            'appointment' => $appointment,
        ]);

    }

    public function update(Request $request, string $uniqid)
    {
        $section = AppointmentSection::where('id', $request->input('appointment_section_id'))->first();
        $customer_package = CustomerPackage::where('id', $request->input('customer_package_id'))->first();

        $data['customer_type'] = $request->input('customer_type');
        
        if($request->input('customer_type') == 'existing_customer') {
            $appointment_customer = HrAppointmentCustomer::where('id', $request->input('hr_appointment_customer_id'))->where('hr_user_id', session('hr_user_id'))->first();
        }
        
        $data['date'] = $request->input('appointment_date'); //
        $data['customer_package_id'] = $request->input('customer_package_id'); //
        $data['title']  = $customer_package->title; //
        $data['store_id'] = $request->input('branch_id'); //
        $data['start'] = $section->start; //
        $data['end'] = $section->end; //
        $data['status'] = $request->input('status'); //
        $data['customer_id'] = $request->input('customer_id'); //
        $data['description'] = $request->input('description'); //
        $data['appointment_section_id'] = $request->input('appointment_section_id'); //
        $data['allday'] = false; //
        
        $appointment = Appointment::where('uniqid', $uniqid)->first();

        $appointment->update($data);
        
        HrAppointmentLink::where('appointment_id', $appointment->id)->delete();
        
        $appointment_data['hr_appointment_customer_id'] = $request->input('hr_appointment_customer_id') ?? null;
        
        if($request->input('customer_type') == 'custom_customer') {
            
            $customer = json_decode($request->input('appointment_custom_customer'));
            
            $customer_data['hr_user_id'] = session('hr_user_id');
            $customer_data['name'] = $customer->name;
            $customer_data['telephone'] = $customer->telephone;
            $customer_data['email'] = $customer->email;
            $customer_data['country_code'] = $customer->country_code;
            $customer_data['status'] = 1;
            
            $hr_appointment_customer = HrAppointmentCustomer::create($customer_data);
            $appointment_data['hr_appointment_customer_id'] = $hr_appointment_customer->id;
        }
        
        $appointment_data['appointment_id'] = $appointment->id;
        $appointment_data['hr_user_id'] = session('hr_user_id');
        
        HrAppointmentLink::create($appointment_data);

        return response()->json([
            'message'   => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = Appointment::where('uniqid', $uniqid)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'appointment has been Deleted!'
            ]);
        }

    }

}
