<?php

namespace App\Http\Controllers\Hr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use App\Models\HrAppointmentCustomer;
use App\Models\AppointmentStatus;
use App\Models\HrPermissionToUser;


class AppointmentCustomerController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = HrPermissionToUser::where('hr_role_id', session('hr_role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('appointment.customers', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('appointment.customer.show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('appointment.customer.create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('appointment.customer.update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('appointment.customer.delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }

    }
    
    public function index()
    {
        
        $customers = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->get();

        $status_options = AppointmentStatus::with(['detail'])->where('status', "1")->get();

        return response()->json([
            'hr_customers'      => $customers,
            'user_id'           => session('hr_user_id'),
            'status_options'    => $status_options,
            'permission'        => $this->permission,
            'permission_type'   => $this->permission_type,
        ]);
    }
    
    public function create()
    {

        return response()->json([
        ]);
    }

    public function store(Request $request)
    {
        $data['hr_user_id'] = session('hr_user_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email') ?? "";
        $data['country_code'] = $request->input('country_code');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');
        $data['uniqid'] = uniqid();

        HrAppointmentCustomer::create($data);

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }


    public function edit(string $uniqid)
    {

        $customer = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->where('uniqid', $uniqid)->first();
        
        if($customer) {
            return response()->json([
                'message'   => 'success',
                'customer'  => $customer,
            ], 200);    
        }
        
        return response()->json([
            'message'   => 'fail',
        ], 200);
        
        
    }

    public function update(Request $request, string $uniqid)
    {

        $response = HrAppointmentCustomer::where('uniqid', $uniqid)->first();
        
        if($response->hr_user_id == session('hr_user_id')) {
            $HrAppointmentCustomer = HrAppointmentCustomer::where('uniqid', $uniqid)->where('hr_user_id', session('hr_user_id'));
        
            $data['name'] = $request->input('name');
            $data['email'] = $request->input('email') ?? "";
            $data['country_code'] = $request->input('country_code');
            $data['telephone'] = $request->input('telephone');
            $data['status'] = $request->input('status');

            $HrAppointmentCustomer->update($data);

            return response()->json([
                'data'      => $data,
                'message' => 'success',
            ]);    
        }
        
        
    }

    public function destroy(string $uniqid)
    {
        
        $response = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->where('uniqid', $uniqid)->delete();
       
        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }

}
