<?php

namespace App\Http\Controllers\Hr\Branch;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Database\Eloquent\Builder;
use PHPUnit\Event\Telemetry\System;
use Illuminate\Support\Facades\DB;

use App\Models\HrCommissionUser;

class CommissionController extends Controller
{
    
    public function index(Request $request)
    {
        
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        $commissions = HrCommissionUser::where('hr_user_id', session('hr_user_id'))
                            ->where('order_date', 'like', '%'.$order_date.'%')
                            ->get();
                            
        $years = DB::table('hr_commission_users')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
                        
        return response()->json([
            'commissions' => $commissions,
            'years' => $years,
            'year'  => $year,
            'month' => $month
        ]);
    }

}
