<?php

namespace App\Http\Controllers\Hr\Branch;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrBranchOrderLink;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Barryvdh\DomPDF\Facade\Pdf;
use PHPUnit\Event\Telemetry\System;


use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    
    public function index(Request $request)
    {
        
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        $orders = HrBranchOrderLink::with(['branch_order', 'branch_order.store', 'branch_order.customer'])
                        ->join('branch_orders', 'branch_orders.id', '=', 'hr_branch_order_links.branch_order_id')
                            ->where('hr_branch_order_links.hr_user_id', session('hr_user_id'))
                            ->where('branch_orders.order_date', 'like', '%'.$order_date.'%')
                            ->get();
                            
        $years = DB::table('branch_orders')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
                        
        return response()->json([
            'orders' => $orders,
            'years' => $years,
            'year'  => $year,
            'month' => $month
        ]);
    }

}
