<?php

namespace App\Http\Controllers\Hr;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use App\Models\HrAppointmentLink;
use App\Models\HrBranchOrderLink;
use App\Models\HrCommissionUser;
use App\Models\Order;
use App\Models\HrReferal;
use App\Models\HrUser;
use App\Models\HrRole;
use App\Models\HrUserPath;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        
        $year = date("Y");
        $month = date("m");
        
        $order_date = $year.'-'.$month;
        
        $appointments = HrAppointmentLink::with(['appointment.customer', 'appointment.statusdetail'])->where('hr_user_id', session('hr_user_id'))->count();
        
        
        $branch_orders = HrBranchOrderLink::with(['branch_order', 'branch_order.store', 'branch_order.customer'])
                        ->join('branch_orders', 'branch_orders.id', '=', 'hr_branch_order_links.branch_order_id')
                            ->where('hr_branch_order_links.hr_user_id', session('hr_user_id'))
                            ->where('branch_orders.order_date', 'like', '%'.$order_date.'%')
                            ->count();
        
        $branch_order_total = HrBranchOrderLink::with(['branch_order', 'branch_order.store', 'branch_order.customer'])
                                ->join('branch_orders', 'branch_orders.id', '=', 'hr_branch_order_links.branch_order_id')
                                ->where('hr_branch_order_links.hr_user_id', session('hr_user_id'))
                                ->where('branch_orders.order_date', 'like', '%'.$order_date.'%')
                                ->sum('total');
                                
        $branch_order_commissions = HrCommissionUser::where('hr_user_id', session('hr_user_id'))->where('order_date', 'like', $order_date.'%')->sum('payable_amount');
        
        $total_orders = Order::with(['order_customers'])
                                ->join('hr_order_links', 'orders.id', '=', 'hr_order_links.order_id')
                                ->where('hr_order_links.hr_user_id', session('hr_user_id'))
                                ->count();
        
        
        
        $month_sales = Order::join('hr_order_links', 'orders.id', '=', 'hr_order_links.order_id')
                                // ->select(DB::raw('SUM(orders.total) as total_sales'))
                                ->where('hr_order_links.hr_user_id', session('hr_user_id'))
                                ->where('orders.order_date', 'like', $order_date.'%')
                                ->sum('orders.total');
                                
        $month_referals = HrReferal::where('hr_user_id', session('hr_user_id'))->where('order_date', 'like', $order_date.'%')->sum('payable');
        
        $total_users = HrUser::with(['hr_role', 'hr_user_path'])
                            ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
                            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
                            ->where('hr_user_paths.hr_user_id', '!=', session('hr_user_id').'%')
                            ->count();
        
        $activited_users = HrUser::with(['hr_role', 'hr_user_path'])
                            ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
                            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
                            ->where('hr_user_paths.hr_user_id', '!=', session('hr_user_id').'%')
                            ->where('hr_users.status', 1)
                            ->count();
                            
        $inactivited_users = HrUser::with(['hr_role', 'hr_user_path'])
                            ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
                            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
                            ->where('hr_user_paths.hr_user_id', '!=', session('hr_user_id').'%')
                            ->where('hr_users.status', 0)
                            ->count();

        return response()->json([
            'appointments'      => $appointments ?? 0,
            'branch_orders'     => $branch_orders ?? 0,
            'branch_order_total'    => $branch_order_total ?? 0,
            'branch_order_commissions'  => $branch_order_commissions ?? 0,
            'total_orders'      => $total_orders ?? 0,
            'month_sales'        => $month_sales ?? 0,
            'month_referals'    => $month_referals,
            'total_users'       => $total_users ?? 0,
            'activited_users'    => $activited_users ?? 0,
            'inactivited_users'    => $inactivited_users ?? 0,
            // 'total_orders'    => $orders->count(),
            // 'order_total'       => $order_total,
            // 'monthly_total'     => $monthly_total,
            // 'user_email' => session()->get('user_email'),
            // 'user_id'   => session()->get('user_id'),
            // 'session_id' => session('session_id')
        ]);
    }

}
