<?php

namespace App\Http\Controllers\Hr;

use App\Http\Controllers\Controller;
use App\Models\HrUser;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;

class LoginController extends Controller
{
    public function index() 
    {
        
    }
    
    public function Login(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');
        session()->flush();
        
        $hr_user = HrUser::where('login_email', '=', $email)->where('status', '1')->first();

        if (Hash::check($password, $hr_user->password) && $hr_user) {
            
            $token = md5(rand(1, 10) . microtime());
            
            $language_id = $hr_user->language_id;
            
            $language = Language::where('id', $language_id)->where('default_language', 1)->first();
            
            session([
                'language_id'       => $language->language_id,
                'locale'            => $language->locale,
                'hr_email'    => $hr_user->email,
                'login_type'        => 'hr',
                'hr_user_id'       => $hr_user->id,
                'hr_role_id'       => $hr_user->hr_role_id,
                'session_id'        => $request->session()->regenerate(),
            ]);

            return response()->json([
                'message'       => 'success',
                'login_type'    => 'hr',
                'token'         => $token,
            ]);
            
        }

        return response()->json([
            'message' => 'fail',
        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }

}
