<?php

namespace App\Http\Controllers\Hr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Contracts\Database\Eloquent\Builder;
use App\Models\HrPermissionToUser;
use App\Models\HrUser;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class RoleController extends Controller
{
    
    public function permissions()
    {
        
        $user = HrUser::where('id', session('hr_user_id'))->first();
        
        $permissions = HrPermissionToUser::where('hr_role_id', $user->hr_role_id)->get();
        
        return response()->json([
            'permissions'   => $permissions,
            'message'   => 'available'
        ]);
    }
    
}
