<?php

namespace App\Http\Controllers\Hr\Sale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\OrderItemDetail;
use App\Models\OrderTransaction;
use App\Models\Item;
use App\Models\ItemDetail;
use App\Models\HrCustomerLink;
use App\Models\CustomerLinkPackage;
use App\Models\Customer;
use App\Models\Package;
use App\Models\OrderUser;
use App\Models\OrderHistory;
use App\Models\PaymentMethod;
use App\Models\OrderCustomer;
use App\Models\OrderStatus;
use App\Models\CustomerPackage;
use App\Models\PackageDetail;
use App\Models\PackageItem;
use App\Models\Setting;
use App\Models\Language;
use App\Models\HrBranchOrderLink;
use App\Models\HrOrderLink;
use App\Models\HrReferal;
use App\Models\HrOther;
use App\Models\HrPermissionToUser;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Barryvdh\DomPDF\Facade\Pdf;
use PHPUnit\Event\Telemetry\System;


use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = HrPermissionToUser::where('hr_role_id', session('hr_role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('sale.orders', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('sale.order.show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('sale.order.create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('sale.order.update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('sale.order.delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }

    }
    
    public function check_telephone(Request $request)
    {
        $telephone = $request->input('telephone');
        $current = $request->input('current');

        $customer = Customer::where('telephone', '=', $telephone);

        if($current) {
            $customer = Customer::where('telephone', '=', $telephone)
                    ->where('telephone', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'message'   => 'fail'
            ]);
        }
        return response()->json([
                'message'   => 'success'
        ]);
        

    }

    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $customer = Customer::where('email', '=', $email);

        if($current) {
            $customer = Customer::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'message'   => 'fail'
            ]);
        }
        
        return response()->json([
                'message'   => 'success'
        ]);

    }
   
    public function index(Request $request)
    {
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        // $orders = HrBranchOrderLink::with(['branch_order', 'branch_order.store', 'branch_order.customer'])
        //                 ->join('branch_orders', 'branch_orders.id', '=', 'hr_branch_order_links.branch_order_id')
        //                     ->where('hr_branch_order_links.hr_user_id', session('hr_user_id'))
        //                     ->where('branch_orders.order_date', 'like', '%'.$order_date.'%')
        //                     ->get();
        
        $orders = Order::with(['order_customers'])
                    ->join('hr_order_links', 'orders.id', '=', 'hr_order_links.order_id')
                    ->addSelect([
                        'amount_paid' => OrderTransaction::selectRaw('sum(payment_amount) as paid')
                        ->whereColumn('order_id', 'orders.id')
                        ->groupBy('order_id')
                    ])
                    ->where('order_date', 'like', '%'.$order_date.'%')
                    ->where('hr_order_links.hr_user_id', session('hr_user_id'))
                    ->orderBy('order_date', 'DESC')
                    ->get();
                            
        $years = DB::table('branch_orders')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
                        
        return response()->json([
            'orders' => $orders,
            'years' => $years,
            'year'  => $year,
            'month' => $month,
            'permission'        => $this->permission,
            'permission_type'   => $this->permission_type,
        ]);
        
        
                    
       
    }

    public function create(Request $request, string $appointment_id = null)
    {
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        $items = Item::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        $packages = Package::with(['detail'])->where('status', '1')->get();
        $customer_links = HrCustomerLink::with(['customer'])->where('hr_user_id', session('hr_user_id'))->get();
        
        return response()->json([
            'payment_methods' => $payment_methods,
            'items' => $items,
            'packages' => $packages,
            'customer_links' => $customer_links,
            'order_statuses' => $order_statuses,
            'appointment'   => $appointment_id
        ]);
    }

    public function store(Request $request)
    {
        
        $data['total'] = $request->input('grand_total');
        $data['payment_option'] = $request->input('payment_option');
        $data['payment_method_id'] = $request->input('payment_method_id');

        $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();
        $data['payment_method'] = $payment_method->detail->title;

        $data['user_id'] = '0';
        
        $data['comment'] = $request->input('comment');
        $data['order_type'] = 'custom';
        $data['order_date'] = $request->input('order_date');

        $status_id = $request->input('order_status_id');

        $status = OrderStatus::with(['detail'])->where('id', $status_id)->first();

        $data['status'] = $status->detail->title ?? NULL;
        $data['customers'] = $request->input('order_customers');
        $data['uniqid'] = uniqid();

        $order = Order::create($data);
        
        $hr_order_link['order_id'] = $order->id;
        $hr_order_link['hr_user_id'] = session('hr_user_id');
        
        HrOrderLink::create($hr_order_link);

        $customer_info = [];
            
        $customer_info['order_id'] = $order->id;
        
        if($request->input('customer_type') == 'existing_customer') {
            $customer_data = Customer::where('id', $request->input('order_customer_id'))->first();
            $customer_info['customer_id'] = $customer_data->id;
            $customer_info['company'] = $customer_data->company;
            $customer_info['name'] = $customer_data->name;
            $customer_info['email'] = $customer_data->email;
            $customer_info['telephone'] = $customer_data->telephone;
        }

        if($request->input('customer_type') == 'custom_customer') {
            $customer = json_decode($request->input('order_custom_customer'));
            $language = Language::where('default_language', 1)->first();
            $customer_info['company'] = $request->input('company');
            $customer_info['name'] = $customer->name;
            $customer_info['email'] = $customer->email;
            $customer_info['country_code'] = $customer->country_code ?? '000';
            $customer_info['telephone'] = $customer->telephone;
            $customer_info['password'] = Hash::make($customer->telephone);
            $customer_info['language_id'] = $language->id;
            $customer_info['status'] = '1';
            $new_customer_data = Customer::create($customer_info);
            $customer_info['customer_id'] = $new_customer_data->id;
            
            $hr_customer_link['customer_id'] = $new_customer_data->id;
            $hr_customer_link['hr_user_id'] = session('hr_user_id');
            HrCustomerLink::create($hr_customer_link);
        }

        OrderCustomer::create($customer_info);

        $order_transaction['order_id'] = $order->id;
        $order_transaction['payment_method_id'] = $request->input('payment_method_id');
        $order_transaction['payment_method'] = $payment_method->detail->title;
        $order_transaction['payment_amount'] = $request->input('payment_amount');

        OrderTransaction::create($order_transaction);

        $items = json_decode($request->input('order_items'));
        
        $total = 0;

        foreach($items as $item) {
            
            $total = $total + $item->total;
            
            $order_item['order_id'] = $order->id;
            $order_item['service_id'] = $item->id ?? 0;
            $order_item['detail'] = $item->detail;
            $order_item['type'] = $item->type;
            $order_item['quantity'] = $item->quantity;
            $order_item['unit_price'] = $item->unit_price;
            $order_item['total'] = $item->total;

            $order_item_result = OrderItem::create($order_item);

            if($item->type == 'item') {
                $item_details = ItemDetail::where('item_id', $item->id)->get();

                foreach($item_details as $item_detail) {
                    $order_item_detail['order_id'] = $order->id;
                    $order_item_detail['order_item_id'] = $order_item_result->id;
                    $order_item_detail['title'] = $item_detail->title;
                    $order_item_detail['language_locale'] = $item_detail->language_locale;
                    OrderItemDetail::create($order_item_detail);
                }
                
            }

            if($item->type == 'package') {
                $package_details = PackageDetail::where('package_id', $item->id)->get();

                foreach($package_details as $package_detail) {
                    $order_item_detail['order_id'] = $order->id;
                    $order_item_detail['order_item_id'] = $order_item_result->id;
                    $order_item_detail['title'] = $package_detail->title;
                    $order_item_detail['language_locale'] = $package_detail->language_locale;
                    OrderItemDetail::create($order_item_detail);
                }

                $packageItems = PackageItem::where('package_id', $item->id)->get();

                foreach($packageItems as $packageItem) {

                    $CustomerPackage['branch_type'] = 'all';

                    if($packageItem->type == 'item') 
                    {
                        $item = Item::with(['detail'])->where('id', $packageItem->item_id)->first();
                        $CustomerPackage['title'] = $item->detail->title;
                        
                        if($item->store_type == 'custom') {
                            $CustomerPackage['branch_type'] = 'custom';
                        }
                        
                    }

                    if($packageItem->type == 'text') 
                    {
                        $CustomerPackage['title'] = $packageItem->detail->title;
                    }

                    $CustomerPackage['order_id'] = $order->id;
                    $CustomerPackage['package_item_id'] = $packageItem->id;
                    $CustomerPackage['item_id'] = $item->id;
                    $CustomerPackage['price'] = $item->price;
                    $CustomerPackage['type'] = $item->type;
                    $CustomerPackage['times'] = $packageItem->times;
                    $CustomerPackage['time_used'] = 0;
                    $CustomerPackage['time_remain'] = $packageItem->times;
                    $CustomerPackage['expiry_date'] = date("Y-m-d", strtotime("+".$packageItem->duration." Months"));
                    $customerPackageInfo = CustomerPackage::create($CustomerPackage);

                    $order_customers = OrderCustomer::where('order_id', $order->id)->get();

                    foreach($order_customers as $order_customer) {
                        $order_customer_info['order_id'] = $order_customer->order_id;
                        $order_customer_info['customer_package_id'] = $customerPackageInfo->id;
                        $order_customer_info['customer_id'] = $order_customer->customer_id;
                        CustomerLinkPackage::create($order_customer_info);
                    }

                }

            }
        }
        
        $hr_user_referal_rate = HrOther::where('key', 'hr_user_referal_rate')->first()->value;
    
        $hr_referal_data['amount']      = $total;
        $hr_referal_data['rate']      = $hr_user_referal_rate;
        $hr_referal_data['payable']      = $total * $hr_user_referal_rate / 100;
        $hr_referal_data['order_id'] = $order->id;
        $hr_referal_data['hr_user_id'] = session('hr_user_id');
        
        HrReferal::create($hr_referal_data);

        // $this->pdf_save($order->id);

        return response()->json([
            'message' => 'success',
        ]);

    }

    public function edit(string $uniqid)
    {
        
        $order = Order::with(['order_customers', 'order_items', 'transactions'])
                // ->leftJoin('hr_order_links', 'orders.id', '=', 'hr_order_links.order_id')
                // ->where('hr_order_links.hr_user_id', session('hr_order_links'))
                ->where('orders.uniqid', $uniqid)
                ->first();
                
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        $items = Item::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        $customer_links = HrCustomerLink::with(['customer'])->get();
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        $packages = Package::with(['detail'])->where('status', '1')->get();
        
        if($order) {
            return response()->json([
                'order'             => $order,
                'payment_methods'   => $payment_methods,
                'items'             => $items,
                'packages'       => $packages,
                'customer_links' => $customer_links,
                'order_statuses'    => $order_statuses,
            ]);    
        }
        
        return response()->json([]);
        

    }

    public function update(Request $request, string $uniqid)
    {
        
        $order = Order::where('uniqid', $uniqid)->first();
        $data['comment'] = $request->input('comment');
        $order->update($data);
        
        $data['order_status_id'] = $request->input('order_status_id');
        $data['payment_option'] = $request->input('payment_option');
        $data['payment_method_id'] = $request->input('payment_method_id');
        $data['payment_amount'] = $request->input('payment_amount');

        if($request->input('payment_option') != 'no_payment' && $request->input('payment_method_id') != null) {
            $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();

            $order_transaction['order_id'] = $order->id;
            $order_transaction['payment_method_id'] = $request->input('payment_method_id');
            $order_transaction['payment_method'] = $payment_method->detail->title;
            $order_transaction['payment_amount'] = $request->input('payment_amount');

            OrderTransaction::create($order_transaction);
        }

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }

    public function destroy(string $uniqid)
    {
        $order = Order::where('uniqid', $uniqid)->first();
        
        OrderTransaction::where('order_id', $order->id)->delete();
        OrderCustomer::where('order_id', $order->id)->delete();
        OrderItem::where('order_id', $order->id)->delete();
        OrderItemDetail::where('order_id', $order->id)->delete();
        OrderHistory::where('order_id', $order->id)->delete();
        $response = Order::find($order->id)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }

    public function pdf_view(string $uniqid)
    {
        $pdf = $this->pdf_data($uniqid);

        return $pdf->stream();
        // return view('files.invoice', compact(['data']));

    }

    public function pdf_data(string $id) {
        $order = Order::with(['items', 'order_customers', 'transactions'])->where('id', $id)->first();
        $total_payment = OrderTransaction::where('order_id', $id)->sum('payment_amount');

        $invoice = Setting::where('type', 'invoice')->get();

        $pdf = Pdf::loadView('files.invoice', [
            'order'     => $order,
            'order_id'  => $id,
            'invoice'    => $invoice,
            'total_payment' => $total_payment
        ]);

        return $pdf;
    }

    public function pdf_save(string $id) {
        
        $pdf = $this->pdf_data($id);

        $pdf->save('sales/orders/order_'.$id.'.pdf');
    }

    public function pdf_download(string $id) {
        $pdf = $this->pdf_data($id);

        return $pdf->download('order_'.$id.'.pdf');
    }

}
