<?php

namespace App\Http\Controllers\Hr\Sale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrReferal;
use Illuminate\Contracts\Database\Eloquent\Builder;


use Illuminate\Support\Facades\DB;

class ReferalController extends Controller
{
    
    public function index(Request $request)
    {
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        $referals = HrReferal::with(['order', 'hr_user'])
                    ->where('hr_user_id', session('hr_user_id'))
                    ->where('order_date', 'like', '%'.$order_date.'%')
                    ->orderBy('order_date', 'desc')
                    ->get();
                            
        $years = DB::table('hr_referals')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
                        
        return response()->json([
            'referals' => $referals,
            'years' => $years,
            'year'  => $year,
            'month' => $month
        ]);
        
    }
    
}
