<?php

namespace App\Http\Controllers\Hr\Sale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrOrderLink;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;

class TransactionController extends Controller
{
    
    public function index()
    {
        
        $orders = HrOrderLink::with(['transactions'])
                    ->where('hr_user_id', session('hr_user_id'))
                    ->orderBy('created_at', 'desc')
                    ->get();
                    
        return response()->json([
            'orders' => $orders,
            'hello' => 'hello'
        ]);
    }

}
