<?php

namespace App\Http\Controllers\Hr\Setting;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrUser;
use App\Models\Language;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;
use PHPUnit\Event\Telemetry\System;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{

    public function check_telephone(Request $request)
    {
        $telephone = $request->input('telephone');
        $current = $request->input('current');

        $customer = Customer::where('telephone', '=', $telephone);

        if($current) {
            $customer = Customer::where('telephone', '=', $telephone)
                    ->where('telephone', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'message'   => 'fail'
            ]);
        }
        return response()->json([
                'message'   => 'success'
        ]);
        

    }

    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $customer = Customer::where('email', '=', $email);

        if($current) {
            $customer = Customer::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'message'   => 'fail'
            ]);
        }
        
        return response()->json([
                'message'   => 'success'
        ]);

    }
   
    public function index()
    {
        
        $user = HrUser::where('id', session('hr_user_id'))->first();
        
        $languages = Language::where('status', 1)->get();
        
        return response()->json([
            'user'             => $user,
            'languages'         => $languages
        ]);
        
    }

    public function update(Request $request)
    {

        $hr_user = HrUser::find(session('hr_user_id'));

        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['telephone'] = $request->input('telephone');
        
        if($request->input('password')) {
            $data['password'] = Hash::make($request->input('password'));
        } else {
            $data['password'] = $hr_user->password;
        }

        $hr_user->update($data);

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);

    }

}
