<?php

namespace App\Http\Controllers\Hr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Contracts\Database\Eloquent\Builder;
use App\Models\HrUser;
use App\Models\HrRole;
use App\Models\HrUserPath;
use App\Models\Language;
use App\Models\HrPermissionToUser;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

// use App\Models\AppointmentSection;
// use App\Models\AppointmentStatus;

class UserController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = HrPermissionToUser::where('hr_role_id', session('hr_role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('users', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('user.show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('user.create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('user.update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('user.delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }

    }
    
    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = HrUser::where('email', '=', $email);

        if($current) {
            $user = HrUser::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'email'     => $email,
            // 'current'   => $current,
            'message'   => 'available'
        ]);
    }
    
    public function check_login_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = HrUser::where('login_email', '=', $email);

        if($current) {
            $user = HrUser::where('login_email', '=', $email)
                    ->where('login_email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'message'   => 'available'
        ]);
    }
    
    public function index()
    {
       
        $session_hr_user_id = session('hr_user_id');
        
        $users = HrUser::with(['hr_role', 'hr_user_path'])
                    ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
            ->where('hr_user_paths.hr_user_id', '!=', session('hr_user_id').'%')
            ->select('hr_users.*', 'hr_user_paths.path')
            ->get();

        return response()->json([
            'session_hr_user_id'    => session('hr_user_id'),
            'users'      => $users,
            'permission'        => $this->permission,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function create()
    {

        // $roles = HrRole::where('status', 1)->get();
        
        $users = DB::table('hr_users')
            ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
            ->select('hr_users.*')
            ->orderByraw('CHAR_LENGTH(hr_user_paths.hr_user_id) ASC')
            ->get();
        
        $languages = Language::where('status', 1)->get();

        return response()->json([
            // 'roles'             => $roles,
            'users'             => $users,
            'languages'         => $languages
        ]);
    }

    public function store(Request $request)
    {
        
        $hrRole = HrRole::where('default', '1')->first();
        
        $data['hr_role_id'] = $hrRole->id;
        $data['superior_id'] = $request->input('superior_id');
        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');
        $data['uniqid'] = uniqid();

        $data['login_email'] = $request->input('login_email');
        $data['password'] = Hash::make($request->input('password'));
        
        $hr_user_res = HrUser::create($data);
        
        $hr_user['hr_user_id'] = $hr_user_res->id;
        $hr_user['path'] = $hr_user_res->id .'-';
        $hr_user_path['team_director'] = $hr_user_res->id;
        
        $hr_user_path_res = HrUserPath::where('hr_user_id', $request->input('superior_id'));
        
        $hr_user['team_director'] = $hr_user_path_res->first()->team_director ?? "";
        
        if($hr_user_path_res->exists()) {
            $hr_user['path'] = $hr_user_path_res->first()->path . $hr_user['path'];
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        }
        
        HrUserPath::create($hr_user);
        
        return response()->json([
            'data'      =>  $data,
            'message'   => 'success',
        ]);

    }


    public function edit(string $uniqid)
    {
        
        $users = DB::table('hr_users')
            ->join('hr_user_paths', 'hr_users.id', '=', 'hr_user_paths.hr_user_id')
            ->where('hr_user_paths.path', 'like', session('hr_user_id').'%')
            ->orderByraw('CHAR_LENGTH(hr_user_paths.hr_user_id) ASC')
            ->select('hr_users.*', 'hr_user_paths.path')
            ->get();
        
        $user = HrUser::where('uniqid', $uniqid)->first();
        
        $languages = Language::where('status', 1)->get();

        return response()->json([
            'user'      => $user,
            'users'     => $users,
            'languages'         => $languages
        ], 200);
    }

    public function update(Request $request, string $uniqid)
    {
        
        $hr_user = HrUser::where('uniqid', $uniqid)->first();
        
        $data['superior_id'] = $request->input('superior_id');
        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        $data['login_email'] = $request->input('login_email');

        if($request->input('password')) {
            $data['password'] = Hash::make($request->input('password'));
        } else {
            $data['password'] = $hr_user->password;
        }
        
        $hr_user->update($data);
        
        HrUserPath::where('hr_user_id', $hr_user->id)->delete();
        
        $hr_user_path['hr_user_id'] = $hr_user->id;
        $hr_user_path['path'] = $hr_user->id .'-';
        $hr_user_path['team_director'] = $hr_user->id;

        $hr_user_path_res = HrUserPath::where('hr_user_id', $request->input('superior_id'));
        
        if($hr_user_path_res->exists()) {
            $hr_user_path['path'] = $hr_user_path_res->first()->path . $hr_user_path['path'];
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        } else if($request->input('superior_id') > 0) {
            $hr_user_path['path'] = $request->input('superior_id').'-'.$hr_user->id .'-';
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        } else {
            $hr_user_path['path'] = $hr_user->id .'-';
            $hr_user_path['team_director'] = $id;
        }
        
        HrUserPath::create($hr_user_path);

        return response()->json([
            'data'      => $data,
            'message'   => 'success',
        ]);
        
        
    }

    public function destroy(Request $request, string $id)
    {
            
            // $type = $request->input('type');
            
            // if($type == 'parent') {
            //     $hr_user_paths = HrUserPath::all();
                
            //     foreach($hr_user_paths as $hr_user_path) {
            //         $path = explode($id.'-', $hr_user_path->path);
            //         $hr_user_path = HrUserPath::find($hr_user_path->id);
            //         $path_data['path'] = isset($path[1]) ? $path[0].$path[1] : $path[0];
            //         $hr_user_path->update($path_data);
            //     }
                
            //     $hr_user = HrUser::find($id);
                
            //     $hr_user_superior = $hr_user->superior_id;
                
            //     HrUser::where('superior_id', $id)->update([
            //         'superior_id' => $hr_user_superior
            //     ]);
                
            // }
            
            // if($type == 'company') {
            //     $hr_user_paths = HrUserPath::all();
                
            //     foreach($hr_user_paths as $hr_user_path) {
                    
            //         $path = explode($id.'-', $hr_user_path->path);
                    
                    
            //         if(isset($path[1])) {
            //             $hr_user_path = HrUserPath::find($hr_user_path->id);    
                        
            //             $path_data['path'] = $path[1];
                        
            //             $hr_user_path->update($path_data);
            //         }
            //     }
                
            //     HrUser::where('superior_id', $id)->update([
            //         'superior_id' => 0
            //     ]);
            // }

            // HrUserPath::where('hr_user_id', $id)->delete();
            // $response = HrUser::find($id)->delete();
            
            // if($response) {
            //     return response()->json([
            //         'path_data' => $path_data,
            //         'message'   => 'success'
            //     ]);
            // }
        
    }
}
