<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use App\Models\Member\MemberOrder;
use App\Models\Member\MemberPoint;
use App\Models\Member\Catalogues\MemberCataloguePointItem;
use App\Models\Member\Catalogues\MemberCatalogueRedeemItem;


class DashboardController extends Controller
{
    
    public function index()
    {
        $point_balance = MemberPoint::where('member_id', session('member_id'))->sum('points');
        $store_count = MemberCatalogueRedeemItem::where('status', 1)->count();
        $order_count = MemberOrder::where('member_id', session('member_id'))->count();
        $transaction_count = MemberPoint::where('member_id', session('member_id'))->count();
        
        return response()->json([
            'point_balance' => $point_balance,
            'store_count'   => $store_count,
            'order_count'   => $order_count,
            'transaction_count' => $transaction_count
        ]);
    }

}
