<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use App\Models\Admin\Member\Member;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;

class LoginController extends Controller
{

    public function Login(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');
        session()->flush();
        
        $member = Member::where('email', '=', $email)->where('status', '1')->first();

        if ($member && Hash::check($password, $member->password)) {
        
            $token = md5(rand(1, 10) . microtime());
            
            $language_id = $member->language_id;
            
            $language = Language::where('id', $language_id)->where('default_language', 1)->first();
            
            session([
                'language_id'       => $language->language_id,
                'locale'            => $language->locale,
                'member_id'         => $member->id,
                'email'             => $member->email,
                'login_type'        => 'member',
                'session_id'        => $request->session()->regenerate(),
            ]);

            return response()->json([
                'message'       => 'success',
                'login_type'    => 'member',
                'session_id'    => session('session_id'),
                'token'         => $token,
            ]);
        
        }    

        return response()->json([
            'message' => 'fail',
        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }

}
