<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
// use App\Models\Admin\Member\Catalogues\MemberCataloguePointItem;
// use App\Models\Language;
use App\Models\Setting;
use App\Models\Member\MemberMileStone;
use App\Models\Member\MemberPoint;



class MembershipController extends Controller
{
   
    public function index()
    {
        $add_point_array = MemberPoint::where('type', 'AddPoint')->where('member_id', session('member_id'))->orderBy('member_order_id', 'desc')->get();
        
        $mile_stones = MemberMileStone::where('status', 1)->orderBy('sort', 'ASC')->get();
        
        $member_point_sum = MemberPoint::where('type', 'AddPoint')
                                    ->where('member_id', session('member_id'))
                                    ->where('member_order_date', ">", date("Y-m-d", strtotime("-1 Year")))
                                    ->sum('points');
        // date("Y-m-d", strtotime("+".$packageItem->duration." Months"));
        
        $currency_code = Setting::where('type', 'system')->where('key', 'currency')->first()->value;
        $currency_symbol = Setting::where('type', 'system')->where('key', 'currency_symbol')->first()->value;
        
        return response()->json([
            'add_point_array'   => $add_point_array,
            'mile_stones'       => $mile_stones,
            'member_point_sum'  => $member_point_sum,
            'currency_code'     => $currency_code,
            'currency_symbol'   => $currency_symbol
        ]);
    }
    

}
