<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Language;
use App\Models\Member\Member;
use Illuminate\Support\Facades\Hash;


class PersonalInformationController extends Controller
{
    
    public function name(Request $request)
    {
        if($request->input('honorific') && $request->input('first_name') && $request->input('last_name')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            
            $data['honorific'] = $request->input('honorific');
            $data['first_name'] = $request->input('first_name');
            $data['last_name'] = $request->input('last_name');
            
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'member'    => $member,
        ]);
        
    }
    
    public function email(Request $request)
    {
        if($request->input('email')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            $data['email'] = $request->input('email');
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'member'    => $member,
        ]);
        
    }
    
    public function telephone(Request $request)
    {
        if($request->input('telephone')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            $data['telephone'] = $request->input('telephone');
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'member'    => $member,
        ]);
        
    }
    
    public function language(Request $request)
    {
        $languages = Language::where('status', 1)->get();
        
        if($request->input('language_id')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            $data['language_id'] = $request->input('language_id');
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'languages' => $languages,
            'member'    => $member,
        ]);
    }
    
    public function birthday(Request $request)
    {
        if($request->input('birthday')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            $data['birthday'] = $request->input('birthday');
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'member'    => $member,
        ]);
    }
    
    public function password(Request $request)
    {
        if($request->input('password')) 
        {
            
            $member = Member::where('id', '=', session('member_id'))->first();
            $data['password'] = Hash::make($request->input('password'));
            $member->update($data);
            
            return response()->json([
                'message' => 'success',
            ]);        
        }
        
        $member = Member::where('id', session('member_id'))->first();
        
        return response()->json([
            'member'    => $member,
        ]);
    }
    
   
    // public function index()
    // {
        
    //     $languages = Language::where('status', 1)->get();
        
    //     $member = Member::where('id', session('member_id'))->first();
        
    //     $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
    //     return response()->json([
    //         'languages' => $languages,
    //         'member'    => $member,
    //         'img_path'  => $img_path
    //     ]);
    // }
    
    // public function store(Request $request)
    // {
        
    //     $member = Member::where('id', '=', session('member_id'))->first();
        
    //     $data['honorific'] = $request->input('honorific');
    //     $data['first_name'] = $request->input('first_name');
    //     $data['last_name'] = $request->input('last_name');
    //     $data['telephone'] = $request->input('telephone');
    //     $data['email'] = $request->input('email');
    //     $data['birthday'] = $request->input('birthday');
    //     $data['language_id'] = $request->input('language_id');
        
    //     if($request->input('password')) {
    //         $data['password'] = Hash::make($request->input('password'));
    //     }

    //     $member->update($data);

    //     return response()->json([
    //         'message'      => 'success',
    //     ]);
    // }
    

}
