<?php

namespace App\Http\Controllers\Member;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Admin\Member\Catalogues\MemberCataloguePointItem;
use App\Models\Setting;
use App\Models\Member\MemberPoint;
use App\Models\Member\MemberOrder;
use App\Models\Member\MemberOrderDetail;
use App\Models\Member\MemberCataloguePointItemStatus;

use Srmklive\PayPal\Services\PayPal as PayPalClient;


class PointItemController extends Controller
{
    private $paypal_order_id;
    private $paypal_url;
    private $uniqid;
    private $clientId;
    private $secret;
    private $currency_code;
    
    public function __construct() {
        $this->currency_code  = Setting::where('type', '=', 'system')->where('key', 'currency')->first()->value;
    }
    
    public function index()
    {
        
        $items = MemberCataloguePointItem::where('status', 1)->get();
        
        $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        return response()->json([
            'items'      => $items,
            'img_path' => $img_path
        ]);
    }
    
    public function show(string $uniqid)
    {
        
        $item = MemberCataloguePointItem::where('uniqid', $uniqid)->where('status', 1)->first();
        
        $paypal_email = Setting::where('type', '=', 'paypal')->where('key', 'email')->first()->value;
        
        $option = Setting::where('type', '=', 'paypal')->where('key', 'option')->first();
        
        $paypal_option = $option->value;
        
        $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        return response()->json([
            'item'      => $item,
            'paypal_option' => $paypal_option,
            'img_path' => $img_path,
        ]);
    }
    
    public function paypal_payment(Request $request)
    {
        $paypal_mode = Setting::where('type', '=', 'paypal')->where('key', 'option')->first()->value;
        if($paypal_mode == 'live')
        {
            $this->clientId = Setting::where('type', '=', 'paypal')->where('key', 'PAYPAL_CLIENT_ID')->first()->value;
            $this->secret = Setting::where('type', '=', 'paypal')->where('key', 'PAYPAL_CLIENT_SECRET')->first()->value;
            $this->base_url = 'https://api-m.paypal.com';
        }
        else {
            $this->clientId = Setting::where('type', '=', 'paypal')->where('key', 'SANDBOX_PAYPAL_CLIENT_ID')->first()->value;
            $this->secret = Setting::where('type', '=', 'paypal')->where('key', 'SANDBOX_PAYPAL_CLIENT_SECRET')->first()->value;    
            $this->base_url = 'https://api-m.sandbox.paypal.com';
        }
        
        $uniqid = $request->input('uniqid');
        
        $price = $request->input('price');
        $quantity = $request->input('quantity') ?? 1;
        
        $total = (int)$price * (int)$quantity;
        
        $total = number_format($total, 2);
        
        $provider = new PayPalClient;
        
        $provider->setApiCredentials(
            [
                'mode'    => 'sandbox',
                'live' => [
                    'client_id'         => $this->clientId,
                    'client_secret'     => $this->secret,
                    'app_id'            => 'APP-80W284485P519543T',
                ],
                'sandbox' => [
                    'client_id'         => $this->clientId,
                    'client_secret'     => $this->secret,
                    'app_id'            => 'APP-80W284485P519543T',
                ],
                'payment_action' => 'Sale',
                'currency'       => $this->currency_code,
                'notify_url'     => 'https://member.hkhec.com/api/member/point_item/paypal/callback',
                'locale'         => 'en_US',
                'validate_ssl'   => true,
            ]
        );
        
        $paypalToken = $provider->getAccessToken();
        
        $response = $provider->createOrder ([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => "https://member.hkhec.com/sales/order/success",
                "cancel_url" => "https://member.hkhec.com/point_item/show/".$uniqid
            ],
            // "no_shipping" => 1,
            // "items" => [
            //     [
            //         "name" => "Yoga Mat",
            //         "description" => "Elastic mat to practice yoga.",
            //         "quantity" => "1",
            //         "unit_amount" => [
            //             "currency_code" => $this->currency_code,
            //             "value" => "50.00"
            //         ],
            //         "tax" => [
            //             "name" => "Sales Tax",
            //             "percent" => "7.25"            
            //         ],
            //         "discount" => [
            //             "percent" => "5"
            //         ],
            //         "unit_of_measure" => "QUANTITY"
            //     ],
            //     [
            //         "name" => "Yoga t-shirt",
            //         "description" => "Elastic mat to practice yoga.",
            //         "quantity" => "1",
            //         "unit_amount" => [
            //             "currency_code" => $this->currency_code,
            //             "value" => "50.00"
            //         ],
            //         "tax" => [
            //             "name" => "Sales Tax",
            //             "percent" => "7.25"            
            //         ],
            //         "discount" => [
            //             "percent" => "5"
            //         ],
            //         "unit_of_measure" => "QUANTITY"
            //     ]
            // ],
            "purchase_units" => [
                [
                    "amount" => [
                        "currency_code" => $this->currency_code,
                        "value" => str_replace(",","", $total)
                    ]
                    
                ]
            ]
        ]);
        
        Session::put('item_uniqid', $uniqid);
        Session::put('item_qty', $quantity);
        Session::put('order_id', $response['id']);
        Session::put('order_total', $total);
       
        if(isset($response['id']) && $response['id'] != null) 
        {
            return $response;
        }
    }
    
    public function paypal_callback(Request $request)
    {
        
        $provider = new PayPalClient;
        
        $paypalToken = $provider->getAccessToken();
        
        $response = $provider->capturePaymentOrder(Session::get('order_id'));
        
        $status = MemberCataloguePointItemStatus::where('default', 1)->first();
        
        if(isset($response['status']) && $response['status'] == "COMPLETED")
        {
            $order_uniqid = md5(date('Y-m-d H:i:s'));
            
            // $check_order = MemberOrder::where('paypal_order_id', Session::get('order_id'));
            
            // if($check_order->doesntExist()) {
                $data['member_id'] = session('member_id');
                $data['store_id'] = 0;
                $data['order_date'] = date("Y-m-d");
                $data['type'] = "AddPoint";
                $data['total'] = session('order_total');
                $data['uniqid'] = $order_uniqid;
                $data['status'] = $status->id;
                $data['paypal_order_id'] = Session::get('order_id');
                
                $order = MemberOrder::create($data);
                
                $uniqid = Session('item_uniqid');
                
                $item = MemberCataloguePointItem::where('uniqid', $uniqid)->where('status', 1);
                
                $item_data['member_order_id'] = $order->id;
                $item_data['title'] = $item->first()->title;
                $item_data['quantity'] = session('item_qty');
                $item_data['point'] = $item->first()->point;
                $item_data['total'] = (int)$item->first()->price * (int)session('item_qty');
                
                MemberOrderDetail::create($item_data);
                
                $member_point['member_id'] = session('member_id');
                $member_point['member_order_id'] = $order->id;
                $member_point['type'] = "AddPoint";
                $member_point['points'] = session('order_total');
                $member_point['member_order_date'] = date("Y-m-d");
                $member_point['expirable'] = 'yes';
                $member_point['expiry_date'] = date("Y-m-d", strtotime("+".(int)$item->first()->duration . " " . $item->first()->duration_type. ""));
                // date("Y-m-d", strtotime("+".$packageItem->duration." Months"));
                MemberPoint::create($member_point);
                
                $new_item_data['quantity'] = (int)$item->first()->quantity - (int)session('item_qty');
                $item->update($new_item_data);

            // }
            // else {
            //     $order = $check_order->first();
            //     $order_uniqid = $order->paypal_order_id;
            // }
            
            return response()->json([
                'success'   => 'success',
                'response'  => $response,
                'order_uniqid'  => $order_uniqid
                
            ]);    
        }
        else {
            return $response;    
        }
        
    }

}
