<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
// use App\Models\Admin\Member\Catalogues\MemberCataloguePointItem;
use App\Models\Language;
use App\Models\Member\Member;
use Illuminate\Support\Facades\Hash;


class ProfileController extends Controller
{
   
    public function index()
    {
        
        $languages = Language::where('status', 1)->get();
        
        $member = Member::where('id', session('member_id'))->first();
        
        $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        return response()->json([
            'languages' => $languages,
            'member'    => $member,
            'img_path'  => $img_path
        ]);
    }
    
    public function store(Request $request)
    {
        
        $member = Member::where('id', '=', session('member_id'))->first();
        
        $data['honorific'] = $request->input('honorific');
        $data['first_name'] = $request->input('first_name');
        $data['last_name'] = $request->input('last_name');
        $data['telephone'] = $request->input('telephone');
        $data['email'] = $request->input('email');
        $data['birthday'] = $request->input('birthday');
        $data['language_id'] = $request->input('language_id');
        
        if($request->input('password')) {
            $data['password'] = Hash::make($request->input('password'));
        }

        $member->update($data);

        return response()->json([
            'message'      => 'success',
        ]);
    }
    

}
