<?php

namespace App\Http\Controllers\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Admin\Member\Catalogues\MemberCatalogueRedeemItem;
use App\Models\Setting;
use App\Models\Member\MemberOrder;
use App\Models\Member\MemberOrderDetail;
use App\Models\CooperationStore;
use App\Models\Member\MemberPoint;
use App\Models\Member\MemberCatalogueRedeemItemStatus;




class RedeemItemController extends Controller
{
    
    
    public function stores(Request $request)
    {
        $value = $request->input('store');
        
        $store_options = CooperationStore::where('name', 'LIKE', '%'.$value.'%')->get();
        
        return response()->json([
            'store_options'     => $store_options,
        ]);
    }
    
    public function index()
    {
        $store_options = CooperationStore::where('status', 1)->get();
        
        $items = MemberCatalogueRedeemItem::where('status', 1)->get();
        
        $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        return response()->json([
            'store_options'        => $store_options,
            'items'      => $items,
            'img_path' => $img_path
        ]);
    }
    
    public function store(string $uniqid)
    {
        
        $store = CooperationStore::where('uniqid', $uniqid)->where('status', 1)->first();
        
        $item_array = MemberCatalogueRedeemItem::with(['store'])->where('cooperation_store_id', $store->id)->where('status', 1)->get();
        
        $img_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        $member_points = MemberPoint::where('member_id', session('member_id'))->sum('points');
        
        return response()->json([
            'store'         => $store,
            'item_array'    => $item_array,
            'img_path'      => $img_path,
            'member_points' => $member_points,
            'member_id'     => session('member_id')
        ]);
    }
    
    public function add_order(Request $request)
    {
        $status = MemberCatalogueRedeemItemStatus::where('default', 1)->first();
        $store = CooperationStore::where('uniqid', $request->input('uniqid'))->first();
        
        $order_date = date("Y-m-d");
        $member_id = session('member_id');
        
        $data['total_points'] = $request->input('order_total_points');
        $data['store_id'] = $store->id;
        $data['member_id'] = $member_id;
        $data['order_date'] = $order_date;
        $data['type'] = 'Redeem';
        $data['uniqid'] = md5(date("Y-m-d h:i:sa"));
        $data['status'] = $status->id;
        
        $order = MemberOrder::create($data);
        
        if($order)
        {
            $transaction['member_id'] = $member_id;
            $transaction['member_order_id'] = $order->id;
            $transaction['type'] = 'redeem';
            $transaction['points'] = 0 - (int)$request->input('order_total_points');
            $transaction['member_order_date'] = $order_date;
            $transaction['expirable'] = 'No';
            
            MemberPoint::create($transaction);
            
            $items = json_decode($request->input('order_items'));
            
            foreach($items as $item)
            {
                $item_data['member_order_id'] = $order->id;
                $item_data['title'] = $item->title;
                $item_data['quantity'] = $item->selected_qty;
                $item_data['point'] = $item->redeem_points;
                $item_data['total'] = $item->redeem_points * $item->selected_qty;
                MemberOrderDetail::create($item_data);
            }
            
            
            return response()->json([
                'message'   => 'success',
                'uniqid'  => $order->uniqid    
            ]);    
        }
        
        return response()->json([
            'message'   => 'fail',
        ]);    
    }
    
   
}
