<?php

namespace App\Http\Controllers\Hr;

use App\Http\Controllers\Controller;
use App\Models\HrUser;
use App\Models\HrRole;
use App\Models\HrUserPath;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;

class RegisterController extends Controller
{
    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = HrUser::where('email', '=', $email);

        if($current) {
            $user = HrUser::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'email'     => $email,
            'current'   => $current,
            'message'   => 'available'
        ]);
    }
    
    public function index(Request $request) 
    {

        $uniqid = $request->input('referal');
        
        $user = HrUser::where('uniqid', $uniqid);
        $role = HrRole::where('default', 1)->first();
        
        if($user->exists()) {
            return response()->json([
                'uniqid'    => $uniqid,
                'superior_id' => $user->first()->id,
                'role_id'   => $role->id,
            ]);
        }
        
        return response()->json([
            'message'   => 'unavailable'
        ]);

    }

    public function Submit(Request $request)
    {

        $data['hr_role_id'] = $request->input('role_id');
        $data['superior_id'] = $request->input('superior_id');
        $data['language_id'] = $request->input('language_id');

        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = 1;
        $data['uniqid'] = uniqid();
        $data['login_email'] = $request->input('email');
        $data['password'] = Hash::make($request->input('password'));
        
        $hr_user_res = HrUser::create($data);
        
        $hr_user['hr_user_id'] = $hr_user_res->id;
        $hr_user['path'] = $hr_user_res->id .'-';
        $hr_user_path['team_director'] = $hr_user_res->id;
        
        $hr_user_path_res = HrUserPath::where('hr_user_id', $request->input('superior_id'));
        
        $hr_user['team_director'] = $hr_user_path_res->first()->team_director ?? "";
        
        if($hr_user_path_res->exists()) {
            $hr_user['path'] = $hr_user_path_res->first()->path . $hr_user['path'];
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        }
        
        HrUserPath::create($hr_user);

        return response()->json([
            'data'      => $data,
            'message' => 'success',
        ]);

    }

}
