<?php

namespace App\Http\Controllers\Member\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Setting;
use App\Models\Member\MemberOrder;


class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        
        $orders = MemberOrder::where('member_id', session('member_id'))->orderBy('order_date', 'desc')->get();
        
        return response()->json([
            'orders'      => $orders
        ]);
    }
    
    public function show(string $uniqid)
    {

        $order = MemberOrder::with(['details', 'store', 'status'])->where('uniqid', $uniqid)->where('member_id', session('member_id'))->first();
        
        return response()->json([
            'order'      => $order,
        ]);
    }
    
   

}
