<?php

namespace App\Http\Controllers\Member\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Setting;
use App\Models\Member\MemberPoint;


class TransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $balance = MemberPoint::where('member_id', session('member_id'))->sum('points');
        
        $transactions = MemberPoint::where('member_id', session('member_id'))->orderBy('member_order_date', 'desc')->get();
        
        return response()->json([
            'balance'       => $balance,
            'transactions'  => $transactions
        ]);
    }
    
    

}
