<?php

namespace App\Http\Controllers\Page;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Config;
use App\Models\Language;
use App\Models\Customer;
use App\Models\Setting;
use App\Mail\ForgotPasswordMail;

class LoginController extends Controller
{
    public function Index()
    {
        return response()->json([
            'success' => true,
        ]);
    }

    public function Submit(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');
        session()->flush();
        $customer = DB::table('customers')->where('email', '=', $email)->first();

        if (Hash::check($password,$customer->password)) {
            $token = md5(rand(1, 10) . microtime());
            $language_id = $customer->language_id;

            $language = Language::where('id', $language_id)->first();

            App::setLocale($language->code);

            session([
                'customer_email' => $customer->email,
                'customer_id' => $customer->id,
                'customer_locale'   => $language->locale,
                'locale'        => $language->locale,
                'session_id'    => $request->session()->regenerate(),
            ]);

            $language_id = $customer->language_id;

            $language = Language::where('id', $language_id)->first();

            return response()->json([
                'success' => true,
                'locale'    => $language->locale,
                'token'     => $token,
                'customer_id' => session('customer_id'),
                'customer_email' => session('customer_email'),
                'session_id'    => session('session_id')

            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Incorrect customer credentials',

        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }
    
    public function forgot_password(Request $request)
    {
        $email = $request->input('email');
        
        if(Customer::where('email', '=', $email)->exists()) {
            $password = $this->getRandomStringRand(8);
            
            $data['title'] = $request->input('title');
        
            $data['content'] = $password;
            
            Customer::where('email', $email)->update(['password' => Hash::make($password)]);
        
            Config::set('mail.default', Setting::where('key', 'MAIL_MAILER')->first()->value);
            Config::set('mail.mailers.smtp.transport', Setting::where('key', 'MAIL_MAILER')->first()->value);
            Config::set('mail.mailers.smtp.host', Setting::where('key', 'MAIL_HOST')->first()->value);
            Config::set('mail.mailers.smtp.port', Setting::where('key', 'MAIL_PORT')->first()->value);    
            Config::set('mail.mailers.smtp.encryption', Setting::where('key', 'MAIL_ENCRYPTION')->first()->value);
            Config::set('mail.mailers.smtp.username', Setting::where('key', 'MAIL_USERNAME')->first()->value);
            Config::set('mail.mailers.smtp.password', Setting::where('key', 'MAIL_PASSWORD')->first()->value);
            Config::set('mail.from.address', Setting::where('key', 'MAIL_FROM_ADDRESS')->first()->value);
            Config::set('mail.from.name', Setting::where('key', 'MAIL_FROM_NAME')->first()->value);

            Mail::to($email)->send(new ForgotPasswordMail($data));    
        }
        
        return response()->json([
            'success'   => true,
            'email'     => $email
        ]);
        
    }
    
    public  function getRandomStringRand($length)
    {
        $stringSpace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $stringLength = strlen($stringSpace);
        $randomString = '';
        for ($i = 0; $i < $length; $i ++) {
            $randomString = $randomString . $stringSpace[rand(0, $stringLength - 1)];
        }
        return $randomString;
    }

}
