<?php

namespace App\Http\Controllers\Page;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use App\Models\OrderCustomer;
use App\Models\Order;
use App\Models\OrderStatus;

class OrderController extends Controller
{
    
    public function index()
    {
        $orders = OrderCustomer::with(['detail'])->where('customer_id', session('customer_id'))->get();
        
        return response()->json([
          'orders' => $orders,
        ]);
    }

    public function show(string $id)
    {
        $order = OrderCustomer::with(['detail', 'items', 'transactions'])
                    ->where('customer_id', session('customer_id'))
                    ->where('order_id', $id)
                    ->first();

        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();

        return response()->json([
            'order' => $order,
            'order_statuses' => $order_statuses,
        ]);
    }

}
