<?php

namespace App\Http\Controllers\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Customer;
use App\Models\Language;
use App\Models\CustomerAddress;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;

class SettingController extends Controller
{
    public function index() {
        $data = Setting::where('key', 'logoImgPreview')->first();
  
        $logo = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$data->value);
        
        // $logo = asset('./laravel/storage/app/public/'.$data->value);
        
        $languages = Language::where('status', 1)->get();
        
        if(!session('locale')) {
            $default_language = Language::where('default_language', 1)->first();
            session(['locale'   => $default_language->locale]);    
        }
        
        return response()->json([
            'logo'      => $logo,
            'languages' => $languages
        ]);
    }

    public function customer_info()
    {
        $customer = Customer::where('id', session('customer_id'))->first();
        $languages = Language::where('status', 1)->get();
        $addresses = CustomerAddress::where('customer_id', session('customer_id'))->get();

        return response()->json([
            'customer' => $customer,
            'languages' => $languages,
            'addresses' => $addresses
        ]);
    }

    public function customer_update(Request $request)
    {

        $customer = Customer::find(session('customer_id'));

        $data['company'] = $request->input('company');
        $data['name'] = $request->input('name');
        $data['wechat'] = $request->input('wechat');
        $data['language_id'] = $request->input('language');
        
        if($request->input('password') != "") {
            $data['password'] = Hash::make($request->input('password'));
        }
        
        $data['status'] = $request->input('status');

        $customer->update($data);

        CustomerAddress::where('customer_id', session('customer_id'))->delete();

        if($request->input('addresses') != null) {
            $addresses = json_decode($request->input('addresses'));

            foreach($addresses as $address) {
                $data['customer_id'] = $customer->id;
                $data['add_1'] = $address->add_1;
                $data['add_2'] = $address->add_2;
                $data['region'] = $address->region;
                $data['country'] = $address->country;
                CustomerAddress::create($data);
            }
        }

        $language_id = $request->input('language');
        $language = Language::where('id', $language_id)->first();
        App::setLocale($language->code);

        session([
            'customer_locale'   => $language->locale,
            'locale'        => $language->locale,
        ]);

        return response()->json([
            'success' => true,
            'data' => $data,
        ]);
    }
}
