<?php

namespace App\Http\Controllers\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Language;
use App\Models\Customer;
use Illuminate\Support\Facades\App;

class SignupController extends Controller
{

    public function signup(Request $request)
    {
        $data['company'] = $request->input('company') ?? '';
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['wechat'] = $request->input('wechat') ?? '';
        $data['language_id'] = $request->input('language_id');
        $data['password'] = Hash::make($request->input('password'));
        $data['status']     = '1';
        
        $customer = Customer::where('email', '=', $data['email'])->doesntExist();
        
        if($customer) {
            $token = md5(rand(1, 10) . microtime());
            
            $new_customer = Customer::create($data);
            
            $language = Language::where('id', $new_customer->language_id)->first();
            
            App::setLocale($language->code);
            
            session([
                'customer_email' => $new_customer->email,
                'customer_id' => $new_customer->id,
                'customer_locale'   => $language->locale,
                'locale'        => $language->locale,
                'session_id'    => $request->session()->regenerate(),
            ]);
            
            return response()->json([
                'success' => true,
                'locale'    => $language->locale,
                'token'     => $token,
                'customer_id' => session('customer_id'),
                'customer_email' => session('customer_email'),
                'session_id'    => session('session_id')

            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'email_existing',
        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }

}
