<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use App\Models\Setting;

class PayPalController extends Controller
{
    /**
     * @noinspection PhpMissingReturnTypeInspection
     */
    public function index()
    {
        return view('checkout');
    }

    /**
     * @return string
     */
    private function getAccessToken(): string
    {
        $client_id = Setting::where('type', '=', 'paypal')->where('key', 'PAYPAL_CLIENT_ID')->first();
        $headers = [
            'Content-Type'  => 'application/x-www-form-urlencoded',
            'Authorization' => 'Basic ' . base64_encode(config('paypal.client_id') . ':' . config('paypal.client_secret'))
        ];

        $response = Http::withHeaders($headers)
                        ->withBody('grant_type=client_credentials')
                        ->post(config('paypal.base_url') . '/v1/oauth2/token');

        return json_decode($response->body())->access_token;
    }

    /**
     * @return string
     */
    public function create(int $amount = 10): string
    {
        $uuid = uuid_create();

        // $headers = [
        //     'Content-Type'      => 'application/json',
        //     'Authorization'     => 'Bearer ' . $this->getAccessToken(),
        //     'PayPal-Request-Id' => $uuid,
        // ];

        // $body = [
        //     "intent"         => "CAPTURE",
        //     "purchase_units" => [
        //         [
        //             "reference_id" => $uuid,
        //             "amount"       => [
        //                 "currency_code" => "HKD",
        //                 "value"         => number_format($amount, 2),
        //             ]
        //         ]
        //     ]
        // ];

        // $response = Http::withHeaders($headers)
        //                 ->withBody(json_encode($body))
        //                 ->post(config('paypal.base_url'). '/v2/checkout/orders');

        // Session::put('request_id', $uuid);
        // Session::put('order_id', json_decode($response->body())->id);

        // return json_decode($response->body())->id;
        
        return response()->json([
            'paypal' => 'paypal',
            'client_id' => config('paypal.client_id')
        ]);
    }

    /**
     * @return mixed
     */
    public function complete()
    {
        $url = config('paypal.base_url') . '/v2/checkout/orders/' . Session::get('order_id') . '/capture';

        $headers = [
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer ' . $this->getAccessToken(),
        ];

        $response = Http::withHeaders($headers)
                        ->post($url, null);

        return json_decode($response->body());
    }
}