<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Customer;
use App\Models\Language;
use App\Models\CustomerAddress;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;

class SettingController extends Controller
{
    public function index(Request $request) {
        
        // session()->flush();
        
        $data = Setting::where('key', 'logoImgPreview')->first();
  
        $logo = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$data->value);
        
        $language = Language::where('default_language', 1)->first();
        
        $languages = Language::where('status', 1)->get();

        if(session('locale')) {
            $language = Language::where('locale', session('locale'))->first();
            $language_id = $language->id;
            session(['locale'   => $language->locale]);
            session(['language_id'   => $language_id]);
        }
        
        if(!session('locale')) {
            $language_id = $language->id;
            session(['locale'   => $language->locale]);
            session(['language_id'   => $language_id]);
        }
        
        
        return response()->json([
            'request'   => $request->input('locale'),
            'logo'      => $logo,
            'default_langauge'  => $language,
            // 'language_id'   => $language_id,
            'locale'        => session('locale'),
            'languages' => $languages,
            'language_id'   => session('language_id')
        ]);
    }

}
