<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use DB;

class UserUniqueFilesFolder
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        if($request->session()->get('user_id')) {

            $user = DB::table('users')->where('id', '=', $request->session()->get('user_id'))->first();

            $folder = $user->email;

            if( !Storage::disk('public')->exists($folder) ) {
                Storage::disk('public')->makeDirectory($folder, 0755, true, true);
            }

            Config::set('elfinder.dir', ["./storage/".$folder]);
            // Config::set('elfinder.dir', $folder_value);

        }
        return $next($request);
    }
}
