<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;

class CustomerMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
              $this->data = $data;
    }

    public function build()
    {
    	$mail = $this->subject($this->data['title'])
                ->view('mail.customer_mail')
                ->with(['content' => $this->data['content']]);
	
	    if ($this->data['attachments']) {
            foreach($this->data['attachments'] as $file)
            {
                $mail->attach($file->getRealPath());
            }
            
        }
    }
    
}
