<?php

namespace App\Models\Admin\Member\Catalogues;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;


class MemberCatalogueRedeemItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_store_id',
        'member_level_id',
        'title',
        'description',
        'quantity',
        'price',
        'redeem_points',
        'tags',	
        'sort',
        'image',
        'uniqid',
        'status'
    ];
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'cooperation_store_id');
    }


}
