<?php
// namespace App\Models;
namespace App\Models\Admin\Member\Marketings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;


class MemberMarketingCoupon extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_store_id',
        'member_level_id',
        'title',
        'description',
        'date_start',
        'date_end',
        'quantity',
        'discount_type',
        'discount_value',
        'sort',
        'uniqid',
        'status',
        'code'
    ];
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'cooperation_store_id');
    }


}
