<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;


class Appointment extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'customer_package_id',
        'title',
        'description',
        'date',
        'appointment_section_id',
        'start',
        'end',
        'store_type',
        'store_id',
        'status',
        'allday',
        'uniqid',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
    
    public function packages(): BelongsTo
    {
        return $this->belongsTo(CustomerPackage::class, 'customer_package_id', 'id');
    }

    public function section(): HasOne
    {
        return $this->hasOne(AppointmentSection::class, 'id', 'appointment_section_id');
    }

    public function statusdetail(): HasOne
    {
        return $this->hasOne(AppointmentStatusDetail::class, 'appointment_status_id', 'status')->where('language_locale', session('locale'));
    }
    
    public function hr_user_link(): HasOne
    {
        return $this->hasOne(HrAppointmentLink::class, 'appointment_id', 'id');
    }

}
