<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AppointmentStatus extends Model
{
    use HasFactory;

    protected $fillable = [
        'sort',
        'status'
    ];

    public function detail(): HasOne
    {
        return $this->hasOne(AppointmentStatusDetail::class)->where('language_locale', session('locale'));
    }

    public function details()
    {
        return $this->hasMany(AppointmentStatusDetail::class);
    }

}
