<?php

namespace App\Models\Branch;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;


class MemberOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id',
        'store_id',
        'order_date',
        'type',
        'total',
        'uniqid',
        'status',
        'paypal_order_id'
    ];

    public function details()
    {
        return $this->hasMany(MemberOrderDetail::class, 'member_order_id', 'id');
    }
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'store_id');
    }
    
    public function status(): HasOne
    {
        return $this->hasOne(MemberCatalogueRedeemItemStatusDetail::class, 'member_catalogue_redeem_item_status_id', 'status')->where('language_locale', session('locale'));
    }
    

}
