<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class BranchCustomer extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_store_id',
        'name',
        'telephone',
        'email',
        'country_code',
        'status'
    ];
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'cooperation_store_id');
    }
    

}
