<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class BranchItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_store_id',
        'branch_category_id',
        'title',
        'description',
        'image',
        'price',
        'sort',
        'type',
        'status'
    ];
    
    public function category(): HasOne
    {
        return $this->hasOne(BranchCategory::class, 'id', 'branch_category_id');
    }
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'cooperation_store_id');
    }


}
