<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class BranchOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_store_id',
        'customer_id',
        'branch_customer_id',
        'appointment_id',
        'telephone',
        'email',
        'country_code',
        'name',
        'comment',
        'total',
        'status',
        'status_id',
        'order_date',
        'customer_type',
        'uniqid',
    ];
   
    public function items()
    {
        return $this->hasMany(BranchOrderItem::class, 'branch_order_id', 'id');
    }
    
    public function transactions()
    {
        return $this->hasMany(BranchOrderTransaction::class);
    }
    
    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'cooperation_store_id');
    }
    
    public function hr_branch_order_link(): HasOne
    {
        return $this->hasOne(HrBranchOrderLink::class, 'branch_order_id', 'id');
    }


}
