<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'sort',
        'status'
    ];

    public function detail(): HasOne
    {
        return $this->hasOne(CategoryDetail::class)->where('language_locale', session('locale'));
    }

    public function details()
    {
        return $this->hasMany(CategoryDetail::class);
    }

}
