<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;


class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'company',
        'name',
        'email',
        'wechat',
        'country_code',
        'telephone',
        'language_id',
        'password',
        'status'
    ];

    public function packages(): BelongsToMany
    {
        return $this->belongsToMany(CustomerPackage::class, 'customer_link_packages', 'customer_id', 'customer_package_id');
    }
    
    public function branch_packages(): BelongsToMany
    {
        return $this->belongsToMany(CustomerPackage::class, 'customer_link_packages', 'customer_id', 'customer_package_id');
    }
    
    public function hr_customer_link(): HasOne
    {
        return $this->hasOne(HrCustomerLink::class);
    }
    
    public function hr_user_path(): HasOneThrough
    {
        return $this->hasOneThrough(HrUserPath::class, HrCustomerLink::class, 'id', 'hr_user_id');
    }


}
