<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CustomerLinkPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'order_id',
        'customer_package_id'
    ];

    
    public function package(): HasOne
    {
        return $this->hasOne(CustomerPackage::class, 'id', 'customer_package_id');
    }


    public function customer_package()
    {
        return $this->hasMany(CustomerPackage::class, 'id', 'customer_package_id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'customer_package_id', 'customer_package_id');
    }
}
