<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

class CustomerPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_item_id',
        'order_id',
        'item_id',
        'title',
        'price',
        'expiry_date',
        'times',
        'time_remain',
        'time_used',
        'type',
        'branch_type',
    ];
    
    public function stores()
    {
        return $this->hasMany(ItemStore::class, 'item_id', 'item_id');
    }
    
    public function item(): HasOne
    {
        return $this->hasOne(Item::class, 'id', 'item_id');
    }
    
}
