<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrAppointmentCustomer extends Model
{
    use HasFactory;

    protected $fillable = [
        'hr_user_id',
        'name',
        'telephone',
        'email',
        'country_code',
        'status',
        'uniqid',
    ];
    
    public function HrUser(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }

}
