<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrAppointmentLink extends Model
{
    use HasFactory;

    protected $fillable = [
        'appointment_id',
        'hr_user_id',
        'hr_appointment_customer_id'
    ];
    
    public function appointment(): HasOne
    {
        return $this->hasOne(Appointment::class, 'id', 'appointment_id');
    }
    
    public function hr_user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }
    
    

}
