<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrBranchOrderLink extends Model
{
    use HasFactory;

    protected $fillable = [
        'hr_user_id',
        'branch_order_id',
        'appointment_id'
    ];
    
    public function hr_user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }
    
    public function branch_order(): HasOne
    {
        return $this->hasOne(BranchOrder::class, 'id', 'branch_order_id');
    }

    
}
