<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrCommissionUser extends Model
{
    use HasFactory;

    protected $fillable = [
        'branch_order_id',
        'hr_user_id',
        'rate',
        'branch_order_total',
        'title',
        'payable_amount',
        'order_date',
        'status',
    ];
    
    public function customer(): HasOne
    {
        return $this->hasOne(Customer::class, 'id', 'customer_id')->where('status', '1');
    }
    
    public function branch_order(): HasOne
    {
        return $this->hasOne(BranchOrder::class, 'id', 'branch_order_id');
    }
    
    public function hr_user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }
    
    

}
