<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrCustomerLink extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'hr_user_id',
        'user_id',
    ];
    
    public function customer(): HasOne
    {
        return $this->hasOne(Customer::class, 'id', 'customer_id')->where('status', '1');
    }
    
    

}
