<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrOrderLink extends Model
{
    use HasFactory;

    protected $fillable = [
        'hr_user_id',
        'order_id'
    ];
    
    public function hr_user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }
    
    public function order(): HasOne
    {
        return $this->hasOne(Order::class, 'id', 'order_id');
    }
    
    public function transactions()
    {
        return $this->hasMany(OrderTransaction::class, 'order_id', 'order_id');
    }

    
}
