<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrReferal extends Model
{
    use HasFactory;

    protected $fillable = [
        'hr_user_id',
        'order_id',
        'rate',
        'amount',
        'payable',
    ];
    
    public function hr_user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'hr_user_id');
    }
    
    public function order(): HasOne
    {
        return $this->hasOne(Order::class, 'id', 'order_id');
    }

}
