<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrUser extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'hr_role_id',
        'language_id',
        'superior_id',
        'name',
        'telephone',
        'email',
        'login_email',
        'password',
        'status',
        'uniqid',
    ];
    
    public function superior(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'superior_id');
    }
    
    public function hr_role(): HasOne
    {
        return $this->hasOne(HrRole::class, 'id', 'hr_role_id');
    }
    
    public function hr_user_path(): HasOne
    {
        return $this->hasOne(HrUserPath::class);
    }

    
}
